import React from 'react';
import LogoKosice from '@/assets/logo_kosice.svg';
import { Logo, PrimaryButton } from '@/lib/idsk';
import Link from 'next/link';

const LoginPage: React.FC = () => {
  return (
    <div className="bg-white rounded-lg shadow p-5 flex flex-col justify-center items-center gap-4 idsk-text-body max-w-96">
      <Logo title="Správca Košice" image={<LogoKosice />}></Logo>
      <p className="mx-8 text-center max-w-64">Prihláste sa do admin portálu mesta Košice.</p>
      <Link href="/signin">
        <PrimaryButton fullWidth>Prihlásiť sa</PrimaryButton>
      </Link>
    </div>
  );
};

export default LoginPage;
