'use client';

import React, { useState } from 'react';
import { HorizontalNavigation, HorizontalNavigationGroup, HorizontalNavigationItem } from '@/lib/idsk';
import { useRouter } from 'next/navigation';
import { cn } from '@/utils';
import { useNotifications } from '@/hooks';
import { ContentLayout, NewMessageForm, withPermission } from '@/components';

const NewMessagePage: React.FC = ({}) => {
  const [type, setType] = useState<'personal' | 'general'>('general');
  const router = useRouter();
  const notify = useNotifications();

  const navigationItemClasses = (isActive: boolean) => {
    return cn({ 'font-bold !bg-primary-medium text-white': isActive });
  };

  const handleMessageSent = () => {
    notify('Správa bola úspešne odslaná');
    router.replace('/spravy');
  };

  return (
    <ContentLayout title="Nová správa">
      <div className="max-w-[64rem]">
        <HorizontalNavigation className="mb-5">
          <HorizontalNavigationGroup
            dropdownLabel={type === 'general' ? 'Vseobecná správa' : 'Personalizovaná správa na KID'}
          >
            <HorizontalNavigationItem
              className={navigationItemClasses(type === 'general')}
              type="button"
              onClick={() => setType('general')}
            >
              Všeobecná správa
            </HorizontalNavigationItem>
            <HorizontalNavigationItem
              className={navigationItemClasses(type === 'personal')}
              type="button"
              active={type === 'personal'}
              onClick={() => setType('personal')}
            >
              Personalizovaná správa na KID
            </HorizontalNavigationItem>
          </HorizontalNavigationGroup>
        </HorizontalNavigation>

        <NewMessageForm type={type} variant="page" onSuccess={handleMessageSent} />
      </div>
    </ContentLayout>
  );
};

export default withPermission(NewMessagePage, 'ACTION_MANAGE_MESSAGE');
