'use client';

import React from 'react';
import { UseQueryResult } from '@tanstack/react-query';

interface QueryHandlerProps {
  error: React.ReactNode;
  loading: React.ReactNode;
  children: (data: any) => React.ReactNode;
  query: UseQueryResult<any, any>;
}

const QueryHandler: React.FC<QueryHandlerProps> = ({ query, error, loading, children }) => {
  const { status, data } = query;

  if (status === 'pending') {
    return loading;
  }

  if (status === 'error') {
    return error;
  }

  return children(data);
};

export default QueryHandler;
