'use client';

import React, { useMemo } from 'react';
import DOMPurify from 'dompurify';
import { MessageAction } from '@/utils';
import { MessageDetailAction } from '@/components';

interface MessageBodyProps {
  body: string;
  actions: MessageAction[];
}

const MessageBody: React.FC<MessageBodyProps> = ({ body, actions }) => {
  const sanitizedHtml = useMemo(() => DOMPurify.sanitize(body.trim()), [body]);
  return (
    <div className="p-5 flex flex-col gap-4 message-detail">
      <div dangerouslySetInnerHTML={{ __html: sanitizedHtml }} />
      {actions.length > 0 && (
        <div className="flex flex-col gap-4">
          {actions.map((action) => (
            <MessageDetailAction key={action.type} action={action} />
          ))}
        </div>
      )}
    </div>
  );
};

export default MessageBody;
