import React from 'react';
import { NavigationLink } from './NavigationLink';
import { auth } from '@/auth';
import { PermissionType } from '@/utils';

const Navigation: React.FC = async () => {
  const session = await auth();
  const permissions = (session?.user.permissions || []) as PermissionType[];

  return (
    <nav className="w-full">
      <ul className="w-full">
        {permissions.includes('ACTION_MANAGE_MESSAGE') && <NavigationLink href="/spravy">Správy</NavigationLink>}
        {permissions.includes('ACTION_MANAGE_TOPIC') && <NavigationLink href="/temy">Témy</NavigationLink>}
      </ul>
    </nav>
  );
};

export default Navigation;
