package sk.kosice.konto.kknotificationservice.repository.message.mapper;

import java.util.Optional;
import org.jooq.JSON;
import org.jooq.RecordMapper;
import sk.kosice.konto.kkmessageservice.repository.model.tables.records.MessageRecord;
import sk.kosice.konto.kknotificationservice.domain.message.entity.ImmutableMessageEntity;
import sk.kosice.konto.kknotificationservice.domain.message.entity.MessageEntity;

public final class JooqMessageRepositoryMapper {

  public static RecordMapper<MessageRecord, MessageEntity> messageRecordMapper() {
    return record ->
        ImmutableMessageEntity.builder()
            .id(record.getId())
            .senderName(record.getSenderName())
            .title(record.getTitle())
            .createdAt(record.getCreatedAt())
            .organizationId(record.getOrganizationId())
            .body(record.getBody())
            .isNotificationSend(record.getIsNotificationSend())
            .bodyType(record.getBodyType())
            .bodyShort(record.getBodyShort())
            .topicId(record.getTopicId())
            .actions(Optional.ofNullable(record.getActions()).map(JSON::data))
            .tags(Optional.ofNullable(record.getTags()).map(JSON::data))
            .recipientKid(Optional.ofNullable(record.getRecipientKid()))
            .build();
  }
}
