package sk.kosice.konto.kknotificationservice.repository.message;

import static sk.kosice.konto.kkmessageservice.repository.model.Tables.MESSAGE;
import static sk.kosice.konto.kkmessageservice.repository.model.Tables.RECIPIENT;
import static sk.kosice.konto.kkmessageservice.repository.model.Tables.TOPIC;

import java.time.OffsetDateTime;
import java.util.List;
import java.util.UUID;
import org.jooq.DSLContext;
import sk.kosice.konto.kknotificationservice.domain.message.entity.MessageEntity;

public interface JooqMessageRepositoryTestSupport {

  default void insertMessages(DSLContext dslContext) {
    final UUID kid = UUID.randomUUID();
    final UUID topicId = UUID.randomUUID();
    dslContext.insertInto(RECIPIENT).values(kid, "test@test.test").execute();
    dslContext
        .insertInto(TOPIC)
        .values(topicId, "topicName", "topicDesc", UUID.randomUUID(), "organizationName")
        .execute();
    dslContext
        .insertInto(MESSAGE)
        .values(
            UUID.randomUUID(),
            UUID.randomUUID(),
            UUID.randomUUID().toString(),
            "title1",
            topicId,
            "content1",
            "TEXT",
            "short",
            null,
            null,
            kid,
            OffsetDateTime.now(),
            false,
            "[\"KOSICE_BARCA\"]")
        .execute();
    dslContext
        .insertInto(MESSAGE)
        .values(
            UUID.randomUUID(),
            UUID.randomUUID(),
            UUID.randomUUID().toString(),
            "title2",
            topicId,
            "content2",
            "TEXT",
            "short",
            null,
            null,
            kid,
            OffsetDateTime.now(),
            false,
            "[\"KOSICE_BARCA\"]")
        .execute();
    dslContext
        .insertInto(MESSAGE)
        .values(
            UUID.randomUUID(),
            UUID.randomUUID(),
            UUID.randomUUID().toString(),
            "title3",
            topicId,
            "content3",
            "TEXT",
            "short",
            null,
            null,
            kid,
            OffsetDateTime.now(),
            true,
            "[\"KOSICE_BARCA\"]")
        .execute();
  }

  default List<MessageEntity> findMessagesWasNotSent(JooqMessageRepository repository) {
    return repository.findNotSentMessages(100);
  }

  default void markMessageAsSent(JooqMessageRepository repository, UUID messageId) {
    repository.markMessageAsSent(messageId);
  }
}
