package sk.kosice.konto.kknotificationservice.business.email.port.service;

import jakarta.inject.Inject;
import jakarta.inject.Named;
import sk.kosice.konto.kknotificationservice.business.AbstractService;
import sk.kosice.konto.kknotificationservice.business.email.port.inbound.SendOneEmailUseCase;
import sk.kosice.konto.kknotificationservice.business.email.port.outbound.EmailSenderPort;
import sk.kosice.konto.kknotificationservice.domain.email.command.SendEmailCommand;

@Named
public class SendOneEmailService extends AbstractService implements SendOneEmailUseCase {
  private final EmailSenderPort emailSenderPort;

  @Inject
  public SendOneEmailService(EmailSenderPort emailSenderPort) {
    this.emailSenderPort = emailSenderPort;
  }

  @Override
  public void execute(SendEmailCommand command) {
    emailSenderPort.sendEmail(command);
  }
}
